# -*- coding: utf-8 -*-
"""
Created on Thu Sep 11 11:30:50 2025

@author: mstep
"""
import math

def get_binary_tree(depth, delta, length, scale, x, y, angle=-math.pi/2,
                    segments=None):
    '''Return a list of segments that draw a binary tree.'''
    if segments is None:
        segments = []

    # Draw our segment.
    x1 = x + length * math.cos(angle)
    y1 = y + length * math.sin(angle)
    segments.append(((x, y), (x1, y1)))

    # If depth > 0, recurse.
    if depth > 0:
        get_binary_tree(depth - 1, delta, length * scale, scale, x1, y1,
                        angle - delta, segments)
        get_binary_tree(depth - 1, delta, length * scale, scale, x1, y1,
                        angle + delta, segments)

    # Return the segments list.
    return segments

#%%
import tkinter as tk
import math

class BinaryTreeApp:
    def __init__(self):
        self.window = tk.Tk()
        self.window.title('binary_tree')
        self.window.protocol('WM_DELETE_WINDOW', self.kill_callback)

        # Make the control widgets.
        top_frame = tk.Frame(self.window, width=50)
        top_frame.pack(side=tk.TOP, padx=(5,0), pady=(5,0), anchor='nw',
                       fill=tk.X)

        wid = 5
        label = tk.Label(top_frame, text='Depth:')
        label.pack(side=tk.LEFT, padx=(10,0))
        self.depth_entry = tk.Entry(top_frame, width=wid, justify='right')
        self.depth_entry.pack(side=tk.LEFT)
        self.depth_entry.insert(0, '10')

        label = tk.Label(top_frame, text='Delta:')
        label.pack(side=tk.LEFT, padx=(10,0))
        self.delta_entry = tk.Entry(top_frame, width=wid, justify='right')
        self.delta_entry.pack(side=tk.LEFT)
        self.delta_entry.insert(0, '45')

        label = tk.Label(top_frame, text='Length:')
        label.pack(side=tk.LEFT, padx=(10,0))
        self.length_entry = tk.Entry(top_frame, width=wid, justify='right')
        self.length_entry.pack(side=tk.LEFT)
        self.length_entry.insert(0, '100')

        label = tk.Label(top_frame, text='Scale:')
        label.pack(side=tk.LEFT, padx=(10,0))
        self.scale_entry = tk.Entry(top_frame, width=wid, justify='right')
        self.scale_entry.pack(side=tk.LEFT)
        self.scale_entry.insert(0, '0.75')

        button = tk.Button(top_frame, text='Draw', width=7, command=self.draw)
        button.pack(side=tk.LEFT, padx=(20,0))

        # Make the canvas.
        self.canvas = tk.Canvas(self.window, bg='white',
            borderwidth=2, relief=tk.SUNKEN, width=600, height=400)
        self.canvas.pack(padx=5, pady=5,
            side=tk.TOP, fill=tk.BOTH, expand=True)

        # Make Enter trigger a draw.
        self.window.bind('<Return>', lambda event: self.draw())

        # Draw the initial tree.
        self.draw()

        # Display the window.
        self.depth_entry.focus_force()
        self.window.mainloop()

    def kill_callback(self):
        # Destroy the tkinter window.
        self.window.destroy()

    def draw(self):
        '''Draw the tree.'''
        # Clear the canvas.
        self.canvas.delete(tk.ALL)

        # Get the drawing area coordinates.
        tk.Tk.update(self.canvas)
        canvas_wid = self.canvas.winfo_width()
        canvas_hgt = self.canvas.winfo_height()

        # Get the tree's parameters.
        depth = int(self.depth_entry.get())
        delta = math.radians(float(self.delta_entry.get()))
        length = float(self.length_entry.get())
        scale = float(self.scale_entry.get())
        x = canvas_wid / 2
        y = canvas_hgt * 0.95

        # Generate the tree segments.
        segments = get_binary_tree(depth, delta, length, scale, x, y)

        # Draw the segments.
        for segment in segments:
            self.canvas.create_line(segment[0], segment[1], fill='red')

#%%
BinaryTreeApp()
