# -*- coding: utf-8 -*-
"""
Created on Wed Oct  8 15:09:03 2025

@author: mstep
"""

def fibonacci_recursive(n):
    '''Use recursion to calculate Fibonacci(n).'''
    if n <= 1:  # Return 0 and 1.
        return n

    # Recursively calculate Fibonacci(n - 1) and Fibonacci(n - 2).
    return fibonacci_recursive(n - 1) + fibonacci_recursive(n - 2)

def fibonacci_dynamic(n, values=None):
    '''Use dynamic programming to calculate Fibonacci(n).'''
    # If we have no saved values, make a new dictionary.
    if values is None:
        values = {}

    # If the value is not in the dictionary, find it and put it there.
    if n not in values:
        if n <= 1:
            values[n] = n
        else:
            values[n] = \
                fibonacci_dynamic(n - 1, values) + \
                fibonacci_dynamic(n - 2, values)

    # Return the value in the dictionary.
    return values[n]

def fibonacci_bottom_up(n):
    '''Use a bottom-up approach to calculate Fibonacci(n).'''
    if n <= 1:  # Return 0 and 1.
        return n

    # Calculate larger values.
    fib_i_minus_2 = 0
    fib_i_minus_1 = 1
    for i in range(2, n+1):
        new_value = fib_i_minus_1 + fib_i_minus_2
        fib_i_minus_2 = fib_i_minus_1
        fib_i_minus_1 = new_value
    return new_value

#%%
import time

STOP_TIME = 1 # Run for this manu seconds for each test.

# Test the recursive function.
start_time = time.time()
i = 35
value = fibonacci_recursive(i)
elapsed_time = time.time() - start_time
print(f'Recursive:\n    Fibonacci({i}) = {value}, {elapsed_time:.2f} sec\n')

# Test the dynamic function.
start_time = time.time()
i = 2000
value = fibonacci_dynamic(i)
elapsed_time = time.time() - start_time
print(f'Dynamic:\n    Fibonacci({i}) = {value}, {elapsed_time:.6f} sec\n')

# Test the dynamic function.
start_time = time.time()
i = 2000
value = fibonacci_bottom_up(i)
elapsed_time = time.time() - start_time
print(f'Bottom-Up:\n    Fibonacci({i}) = {value}, {elapsed_time:.6f} sec\n')

# Calculate Fibonacci(1,000,000)
# start_time = time.time()
# i = 1000000
# value = fibonacci_bottom_up(i)
# elapsed_time = time.time() - start_time
# print(f'Time: {elapsed_time:.6f} sec\n')

# test_value = 1
# for i in range(1000000):
#     test_value *= 10
#     if value < test_value:
#         print(f'Digits: {i - 1}')
#         break
