# -*- coding: utf-8 -*-
"""
Created on Thu Nov  7 15:31:13 2024

@author: mstep
"""
import tkinter as tk
from tkinter import messagebox

class MoveBorderlessWindowApp:
    def __init__(self):
        self.window = tk.Tk()
        self.window.title('skinned_form_part1')
        self.window.protocol('WM_DELETE_WINDOW', self.kill_callback)
        self.window.geometry('400x300')

        # Remove the window's borders.
        self.window.overrideredirect(True)
        self.window.configure(borderwidth=0, highlightthickness=0)

        # Make the window topmost.
        # (It's not in the task list so otherwise it's hard to find.)
        self.window.attributes("-topmost", True)

        # Initially don't ignore drag.
        self.ignore_drag = False

        # Make cyan pieces tansparent.
        self.window.wm_attributes('-transparentcolor', 'cyan')
        self.window.configure(bg='cyan') 

        # Resizing rectangles.
        size = 10

        # Top.
        top_frame = tk.Frame(self.window, bg='cyan', highlightthickness=0)
        top_frame.pack(side=tk.TOP, fill=tk.X)
        self.nw_canvas = tk.Canvas(top_frame, bg='yellow',
                                   cursor='top_left_corner',
                                   width=3*size, height=3*size,
                                   highlightthickness=0)
        self.nw_canvas.pack(side=tk.LEFT)

        self.kill_rect = self.nw_canvas.create_rectangle(
            size, size, 2 * size, 2 * size, fill='black')
        self.nw_canvas.tag_bind(self.kill_rect, '<Button-1>',
                                self.kill_clicked)
        self.nw_canvas.tag_bind(self.kill_rect, '<Enter>',
                                self.kill_mouse_enter)
        self.nw_canvas.tag_bind(self.kill_rect, '<Leave>',
                                self.kill_mouse_leave)

        self.ne_canvas = tk.Canvas(top_frame, bg='yellow',
                                   cursor='top_right_corner',
                                   width=3*size, height=3*size,
                                   highlightthickness=0)
        self.ne_canvas.pack(side=tk.RIGHT)

        self.n_canvas = tk.Canvas(top_frame, bg='orange',
                                  cursor='top_side',
                                  height=size, highlightthickness=0)
        self.n_canvas.pack(side=tk.TOP, fill=tk.X)

        self.drag_canvas = tk.Canvas(top_frame, bg='light blue',
                                     cursor='fleur',
                                     height=2*size, highlightthickness=0)
        self.drag_canvas.pack(side=tk.TOP, fill=tk.X)
        self.drag_canvas.create_text(3, 2, text='skinned_form_part1', fill='red',
                                     anchor='nw')


        # Bottom.
        bottom_frame = tk.Frame(self.window, bg='cyan', highlightthickness=0)
        bottom_frame.pack(side=tk.BOTTOM, fill=tk.X)

        self.sw_canvas = tk.Canvas(bottom_frame, bg='yellow',
                                   cursor='bottom_left_corner',
                                   width=size, height=size)
        self.sw_canvas.pack(side=tk.LEFT)

        self.se_canvas = tk.Canvas(bottom_frame, bg='yellow',
                                   cursor='bottom_right_corner',
                                   width=size, height=size)
        self.se_canvas.pack(side=tk.RIGHT)

        self.s_canvas = tk.Canvas(bottom_frame, bg='orange',
                                  cursor='bottom_side',
                                  height=size)
        self.s_canvas.pack(side=tk.BOTTOM, fill=tk.X)


        # Left.
        self.w_canvas = tk.Canvas(self.window, bg='orange',
                                  cursor='left_side',
                                  width=size)
        self.w_canvas.pack(side=tk.LEFT, fill=tk.Y)


        # Right.
        self.e_canvas = tk.Canvas(self.window, bg='orange',
                                  cursor='right_side',
                                  width=size)
        self.e_canvas.pack(side=tk.RIGHT, fill=tk.Y)


        # Bind mouse events and set highlightthickness to 0.
        canvases = [self.drag_canvas, self.nw_canvas, self.n_canvas,
                    self.ne_canvas, self.e_canvas, self.se_canvas,
                    self.s_canvas, self.sw_canvas, self.w_canvas]
        for widget in canvases:
            widget.bind('<Button-1>', self.mouse_down)
            widget.bind('<B1-Motion>', self.mouse_drag)
            widget.config(highlightthickness=0)

        # Central frame.
        self.center_frame = tk.Frame(self.window, bg='plum1', borderwidth=0)
        self.center_frame.pack(side=tk.TOP, expand=True, fill=tk.BOTH)

        # Build the main non-border widgets.
        self.make_widgets()

        # Display the window.
        self.window.focus_force()
        self.window.mainloop()

    def kill_callback(self):
        # Destroy the tkinter window.
        if messagebox.askyesno('Close',
                               'Do you really want to close the program?'):
            self.window.destroy()

    def kill_mouse_enter(self, event):
        # Display the pirate cursor.
        self.nw_canvas.config(cursor='pirate')

    def kill_mouse_leave(self, event):
        # Display the NW cursor.
        self.nw_canvas.config(cursor='top_left_corner')

    def kill_clicked(self, event):
        '''The user clicked the close button. Kill the window.'''
        self.ignore_drag = True
        self.kill_callback()
        self.ignore_drag = False

    def mouse_down(self, event):
        '''The user pressed the mouse down on one of the handles.'''
        # Save the mouse position.
        self.start_x = event.x
        self.start_y = event.y

    def mouse_drag(self, event):
        '''The user is dragging over one of the handles.'''
        if self.ignore_drag:
            return

        # Get the window's current size and position.
        geometry = self.window.geometry().replace('+', 'x')
        wid, hgt, x, y = [int(value) for value in geometry.split('x')]

        # Get the mouse position.
        new_x = event.x
        new_y = event.y

        # Update the window's size and position.
        widget = event.widget
        match widget:
            case self.drag_canvas:
                x = x + (new_x - self.start_x)
                y = y + (new_y - self.start_y)
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case self.nw_canvas:
                x = x + (new_x - self.start_x)
                wid -= new_x - self.start_x
                y = y + (new_y - self.start_y)
                hgt -= new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case self.n_canvas:
                y = y + (new_y - self.start_y)
                hgt -= new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case self.ne_canvas:
                wid += new_x - self.start_x
                y = y + (new_y - self.start_y)
                hgt -= new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case self.e_canvas:
                wid += new_x - self.start_x
                self.window.geometry(f'{wid}x{hgt}')
            case self.se_canvas:
                wid += new_x - self.start_x
                hgt += new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}')
            case self.s_canvas:
                hgt += new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}')
            case self.w_canvas:
                x = x + (new_x - self.start_x)
                wid -= new_x - self.start_x
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case self.sw_canvas:
                x = x + (new_x - self.start_x)
                wid -= new_x - self.start_x
                hgt += new_y - self.start_y
                self.window.geometry(f'{wid}x{hgt}+{x}+{y}')
            case _:
                raise(Exception(f'Unknown widget {widget}'))

    def make_widgets(self):
        '''Make the main app widgets.'''
        # Make a button in the center of the frame.
        close_button = tk.Button(self.center_frame, text='Close', width=7,
                                 command=self.kill_callback)
        close_button.grid(row=1, column=1)

        self.center_frame.columnconfigure(0, weight=1) 
        self.center_frame.columnconfigure(2, weight=1) 
        self.center_frame.rowconfigure(0, weight=1) 
        self.center_frame.rowconfigure(2, weight=1) 

#%%
MoveBorderlessWindowApp()
print('Done')
